<?php
ob_start();
session_start();





/*
 * required files
 */
require_once ('./models/PHP-MySQLi-Database-Class/MysqliDb.php');
require_once("./models/config.php"); // connect with db and load site info
require_once("./models/functions.php"); // site functions





/*
 * page variables
 */
$page_name = 'Dashboard';
$page_name_single = '';






/*
 * if user is not logged in redirect to login
 */
if ((!isset($_SESSION['sess_user_id']) || (trim(isset($_SESSION['sess_user_id'])) == ''))) {
  header("location: index.php");
  exit();
} else {
  /*
   * set session variables
   */
  $user_id = $_SESSION['sess_user_id'];
  $username = $_SESSION['sess_username'];
  $user_email = $_SESSION['sess_user_email'];
}






/*
 * active menu links
 */
$menu_active = 'dashboard';
$menu_sub_active = '';
?>
<!DOCTYPE html>
<html>
  <head lang="en">

    <title><?= $page_name ?> | <?php echo $site_name; ?> - <?php echo $site_slogan; ?></title>
    <meta name="description" content="<?php echo $site_name . '.' . $site_slogan ?>">

    <?php require_once './includes/head.php'; ?>


  </head>
  <body class="with-side-menu theme-side-litmus-blue">

    <?php require_once './includes/header.php'; ?>

    <?php require_once './includes/side-menu.php'; ?>

    <div class="page-content">
      <div class="container-fluid">

        <header class="section-header">
          <div class="tbl">
            <div class="tbl-row">
              <div class="tbl-cell">
                <h3><?= $page_name ?></h3>
              </div>
            </div>
          </div>
        </header>

        <div class="row">
          <div class="col-xs-6 col-sm-3">
            <a class="widget widget-simple-sm-fill" href="sms.php">
              <div class="widget-simple-sm-icon">
                <i class="font-icon fa fa-envelope-o"></i>
              </div>
              <div class="widget-simple-sm-fill-caption">Send SMS</div>
            </a>
          </div><!--.widget-simple-sm-fill-->
          <div class="col-xs-6 col-sm-3">
            <a class="widget widget-simple-sm-fill" href="email.php">
              <div class="widget-simple-sm-icon">
                <i class="font-icon fa fa-envelope-o"></i>
              </div>
              <div class="widget-simple-sm-fill-caption">Send Email</div>
            </a>
          </div><!--.widget-simple-sm-fill-->
          <?
          if ($superadmin == 1) {
            ?>

            <div class="col-xs-6 col-sm-3">
              <a class="widget widget-simple-sm-fill" href="customers.php">
                <div class="widget-simple-sm-icon">
                  <i class="font-icon fa fa-user"></i>
                </div>
                <div class="widget-simple-sm-fill-caption">Customers</div>
              </a>
            </div><!--.widget-simple-sm-fill-->
          <? } ?>
        </div>
        <div class="row">
          <div class="col-xs-6 col-sm-3">
            <a class="widget widget-simple-sm-fill" href="settings.php">
              <div class="widget-simple-sm-icon">
                <i class="glyphicon glyphicon-cog font-icon"></i>
              </div>
              <div class="widget-simple-sm-fill-caption">User Settings</div>
            </a>
          </div><!--.widget-simple-sm-fill-->

          <?
          if ($superadmin == 1) {
            ?>

            <div class="col-xs-6 col-sm-3">
              <a class="widget widget-simple-sm-fill" href="site_info.php">
                <div class="widget-simple-sm-icon">
                  <i class="font-icon fa fa-briefcase"></i>
                </div>
                <div class="widget-simple-sm-fill-caption">Software Settings</div>
              </a>
            </div><!--.widget-simple-sm-fill-->
          <? } ?>

        </div>


      </div><!--.container-fluid-->
    </div><!--.page-content-->

    <?php require_once './includes/footer.php'; ?>


  </body>
</html>